MObject->Fields (
  body_pos => {default => 'standing'},
  has_body_pos => {default => 0},
);

my %bp_can = (
  floating => {map+($_,1),qw(
    fly
    fight
    sit
    sleep
    reach_object
    reach_inventory
    move
    look
    hear
  )},
  standing => {map+($_,1),qw(
    fight
    sit
    sleep
    reach_object
    reach_inventory
    move
    look
    hear
  )},
  sitting => {map+($_,1),qw(
    stand
    sleep
    reach_inventory
    look
    hear
  )},
  sleeping => {map+($_,1),qw(
    wake
  )},
  stunned => {map+($_,1),qw(
    look
    hear
  )},
  unconscious => {map+($_,1),qw(
  )},
  dying => {map+($_,1),qw(
  )},
);
my %bp_gain = qw(
  floating 1
  standing 1
  swimming 0.9
  
  sitting 1.6
  sleeping 3.4
  
  stunned 0.33
  unconscious 0.2
  dying -1
);

my %bp_desc = (
  floating => 'floating',
  standing => 'standing',
  sitting => 'sitting',
  sleeping => 'sleeping',
  stunned => 'lying stunned',
  unconscious => 'lying unconscious',
  dying => 'dying',
);

MObject->Methods (
bp_can => sub {
  my ($self, $action) = @_;
  return $self->has_body_pos ? ($bp_can{$self->body_pos} || {} )->{$action} : 1;
},
bp_assert => sub {
  my ($self, $action, $adesc) = @_;
  my $bp = $self->body_pos;
  unless (!$bp or ($bp_can{$bp} || {} )->{$action} ) {
    if ($bp eq 'sleeping') {
      die 'CFAIL:In your dreams, or what?';
    } else {
      die "CFAIL:You can't ".($adesc || 'do that')." while you're $bp.";
    }
  }
  return 1;
},
bp_desc => sub {
  my ($self) = @_;
  return $bp_desc{$self->body_pos} || $self->body_pos;
},
do_stun => sub {
  my ($self, $stime) = @_;
  
  $self->nact('<self.name> <self.is?are:is> stunned!');
  $self->body_pos('stunned');
  my $hook = sub {
    my %data = @_;
    MObject->by_id($data{owner})->body_pos('sitting');
  $self->nact('<self.name> recover<self.is!s>.');
  };
  MScheduler->add_task(
    name => 'Recover from Stun', 
    'time' => $stime,
    owner => $self->id,
    hook => $hook,
    abort => $hook,
  );
}
);

Hooks (
recovery_modifier => sub {
  my ($self) = @_;
  if (!exists $bp_gain{$self->body_pos}) {
    mudlog "ERROR/WORLD: no gain value for body position '@{[$self->body_pos]}'.";
    return;
  }
  return $bp_gain{$self->body_pos};
},
);

my $set_pos = sub {
  my ($self, $into, $pos, $pverb, $pdnorm, $pdon) = @_;
  $self->bp_assert($pverb, $pverb);
  
  if ($into) { 
    $into->can_contain($self) or die "CFAIL:There's no room for you ".$into->enter_prep." ".$into->name.".";
    $self->body_pos($pos);
    $self->nact($pdon, target => $into);
    $self->move_into($into);
  } else {
    $self->body_pos($pos);
    $self->nact($pdnorm);
  }
};

my $pos_cmd = sub {
  my ($pos, $pverb, $pdnorm, $pdon) = @_;
  return sub {
    my ($self, $args) = @_;
    
    my $into;
    if ($args) {
      $into = $self->object_find($args, no_self_contents => 1);
    } else {
      foreach (@{$self->container->contents}) {
        next unless $self->can_see($_) and $_->get_val("for_$pos") and $_->can_contain($self);
        $into = $_; last;
      }
    }
    $set_pos->($self, $into, $pos, $pverb, $pdnorm, $pdon);
  };
};

MObject->Commands (
  stand => {code => sub {
    my ($self) = @_;
    $self->bp_assert('stand', 'stand');
    my $oldpos = $self->body_pos;
    $self->body_pos('standing');
    my $cont = $self->container;
    if ($cont->get_val("for_$oldpos")) {
      my $exit_prep = 'out of';
      $exit_prep = 'off' if $cont->enter_prep eq 'on';
      $self->nact("<self> get<self!s> $exit_prep <cont> and stand up.", cont => $cont);
      $self->move_into($cont->container);
    } else {
      $self->nact('<self> stand<self!s> up.');
    }
  }},
  sit => {code => $pos_cmd->('sitting', 'sit', '<self> sit<self!s> down.', '<self> sit<self!s> down on <target>.')},
  'sleep' => {code => $pos_cmd->('sleeping', 'sleep', '<self> lie<self.is!s> down and falls asleep.', '<self> lie<self!s> down on <target> and falls asleep.')},
  wake => {code => sub {
    my ($self) = @_;
    $self->bp_assert('wake', 'wake up');
    $self->body_pos('sitting');
    $self->nact('<self> wake<self!s> up.');
  }},
);

MObject->CommandAliases(
  #wake => [qw(awaken)],
);


